<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/admin/partials
 */

$servers = get_option( $this->plugin_name . "-servers" );
if(!is_array($servers)) {
    $servers = array();
}
foreach($servers as $i => $server) {
    if(isset($servers[$i]['long'])) {
        $servers[$i]['longitude'] = $servers[$i]['long'];
    }
    if(isset($servers[$i]['lat'])) {
        $servers[$i]['latitude'] = $servers[$i]['lat'];
    }
    if(isset($servers[$i]['url'])) {
        $servers[$i]['url_ip'] = $servers[$i]['url'];
    }
}
$flags = plugins_url( $this->plugin_name ) . '/public/images/flags/';
settings_errors();
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<main class="font-sans space-y-10 md:my-8 pr-5">
    <div id="view-servers" class="animate__animated animate__animated">
        <div class="flex flex-col md:flex-row md:justify-between md:items-center">
            <?php if(count($servers) > 0) { ?>
            <div class="section-title">
                <h2 class="text-xl font-bold"><?php _e('List of Servers') ?></h2>
                <p class="text-gray-500"><?php _e('Below are the existing servers that will be used in DNS queries.') ?></p>
            </div>
            <?php } else { ?>
            <div class="section-title">
                <h2 class="text-xl font-bold"><?php _e('No Servers Available') ?></h2>
                <p class="text-gray-500"><?php _e('Click on the below button to add a server to Global DNS.') ?></p>
            </div>
            <?php } ?>
            <div class="flex space-x-2">
                <button id="global-dns-import" class="bg-sky-600 text-white rounded px-3 py-2 mt-5 flex items-center gap-2" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                    </svg>
                    <?php _e('Import') ?>
                </button>
                <?php if(count($servers) > 0) { ?>
                <button id="global-dns-export" class="bg-gray-700 text-white rounded px-3 py-2 mt-5 flex items-center gap-2" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                    </svg>
                    <?php _e('Export') ?>
                </button>
                <button id="global-dns-delete-all" class="bg-red-600 text-white rounded px-3 py-2 mt-5 flex items-center gap-2" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                    </svg>
                    <?php _e('Delete All') ?>
                </button>
                <?php } ?>
            </div>
        </div>
        <div class="grid grid-cols-1 xl:grid-cols-2 3xl:grid-cols-3 gap-5 items-center mt-5 sortable">
            <?php foreach($servers as $key => $server) { ?>
            <div class="server bg-white shadow-md rounded-lg p-5">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-5">
                        <img class="h-10 cursor-move" src="<?php _e($flags . strtolower($server['country'])) ?>.svg" alt="<?php _e($server['country']) ?>">
                        <div>
                            <h4 class="font-semibold text-lg"><?php _e($server['name']) ?></h4>
                            <h6 class="truncate w-72"><?php _e($this->cleanUrl($server['url_ip'])) ?></h6>
                        </div>
                    </div>
                    <div class="flex items-center space-x-5">
                        <div class="edit-server cursor-pointer" data-id="<?php _e($key) ?>" data-data='<?php _e(json_encode($server)) ?>'>
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                            </svg>
                        </div>
                        <div class="delete-server cursor-pointer" data-id="<?php _e($key) ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-red-700" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
        <button id="add-edit-btn" class="bg-green-500 text-white rounded px-3 py-2 mt-5 flex items-center gap-3" type="button">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd" />
            </svg>
            <?php _e('Add New Server') ?>
        </button>
    </div>
    <div id="add-edit-server" class="animate__animated animate__animated hidden">
        <div id="go-back" class="flex items-center gap-3 cursor-pointer mb-5">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M7 16l-4-4m0 0l4-4m-4 4h18" />
            </svg>
            <span class="font-semibold"><?php _e('Back to All Servers') ?></span>
        </div>
        <div class="add-server-views section-title">
            <h2 class="text-xl font-bold"><?php _e('Add New Server') ?></h2>
            <p class="text-gray-500"><?php _e('You can use public DNS servers as long as shell_exec function is enabled in your hosting settings.') ?></p>
        </div>
        <div class="edit-server-views section-title">
            <h2 class="text-xl font-bold"><?php _e('Edit Server') ?></h2>
        </div>
        <form action="options.php" method="post">
            <input type="hidden" name="id">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-5 my-5">
                <div class="space-y-1">
                    <label class="block" for="name"><?php _e('Server Name') ?></label>
                    <input class="w-full text-sm" type="text" name="name" id="name" placeholder="<?php _e('Mumbai, India') ?>" required>
                </div>
                <div class="space-y-1">
                    <label class="block" for="url_ip"><?php _e('URL or IP') ?></label>
                    <input class="w-full text-sm" type="text" name="url_ip" id="url_ip" placeholder="<?php _e('8.8.8.8') ?>" required>
                </div>
                <div class="space-y-1">
                    <label class="block" for="latitude"><?php _e('Latitude') ?></label>
                    <input class="w-full text-sm" type="number" step=".0000000001" min="-90" max="90" name="latitude" id="latitude" placeholder="<?php _e('72.8777') ?>" required>
                </div>
                <div class="space-y-1">
                    <label class="block" for="longitude"><?php _e('Longitude') ?></label>
                    <input class="w-full text-sm" type="number" step=".0000000001" min="-180" max="180" name="longitude" id="longitude" placeholder="<?php _e('19.0760') ?>" required>
                </div>
                <div class="space-y-1">
                    <label for="country"><?php _e('Country') ?></label>
                    <select class="w-full text-sm" name="country" required>
                        <option value="null" disable selected><?php _e('Select a Country') ?></option>
                        <option value="AF"><?php _e('Afghanistan') ?></option>
                        <option value="AX"><?php _e('Aland Islands') ?></option>
                        <option value="AL"><?php _e('Albania') ?></option>
                        <option value="DZ"><?php _e('Algeria') ?></option>
                        <option value="AS"><?php _e('American Samoa') ?></option>
                        <option value="AD"><?php _e('Andorra') ?></option>
                        <option value="AO"><?php _e('Angola') ?></option>
                        <option value="AI"><?php _e('Anguilla') ?></option>
                        <option value="AQ"><?php _e('Antarctica') ?></option>
                        <option value="AG"><?php _e('Antigua and Barbuda') ?></option>
                        <option value="AR"><?php _e('Argentina') ?></option>
                        <option value="AM"><?php _e('Armenia') ?></option>
                        <option value="AW"><?php _e('Aruba') ?></option>
                        <option value="AU"><?php _e('Australia') ?></option>
                        <option value="AT"><?php _e('Austria') ?></option>
                        <option value="AZ"><?php _e('Azerbaijan') ?></option>
                        <option value="BS"><?php _e('Bahamas') ?></option>
                        <option value="BH"><?php _e('Bahrain') ?></option>
                        <option value="BD"><?php _e('Bangladesh') ?></option>
                        <option value="BB"><?php _e('Barbados') ?></option>
                        <option value="BY"><?php _e('Belarus') ?></option>
                        <option value="BE"><?php _e('Belgium') ?></option>
                        <option value="BZ"><?php _e('Belize') ?></option>
                        <option value="BJ"><?php _e('Benin') ?></option>
                        <option value="BM"><?php _e('Bermuda') ?></option>
                        <option value="BT"><?php _e('Bhutan') ?></option>
                        <option value="BO"><?php _e('Bolivia') ?></option>
                        <option value="BQ"><?php _e('Bonaire') ?></option>
                        <option value="BA"><?php _e('Bosnia and Herzegovina') ?></option>
                        <option value="BW"><?php _e('Botswana') ?></option>
                        <option value="BV"><?php _e('Bouvet Island') ?></option>
                        <option value="BR"><?php _e('Brazil') ?></option>
                        <option value="IO"><?php _e('British Indian Ocean Territory') ?></option>
                        <option value="BN"><?php _e('Brunei Darussalam') ?></option>
                        <option value="BG"><?php _e('Bulgaria') ?></option>
                        <option value="BF"><?php _e('Burkina Faso') ?></option>
                        <option value="BI"><?php _e('Burundi') ?></option>
                        <option value="KH"><?php _e('Cambodia') ?></option>
                        <option value="CM"><?php _e('Cameroon') ?></option>
                        <option value="CA"><?php _e('Canada') ?></option>
                        <option value="CV"><?php _e('Cape Verde') ?></option>
                        <option value="KY"><?php _e('Cayman Islands') ?></option>
                        <option value="CF"><?php _e('Central African Republic') ?></option>
                        <option value="TD"><?php _e('Chad') ?></option>
                        <option value="CL"><?php _e('Chile') ?></option>
                        <option value="CN"><?php _e('China') ?></option>
                        <option value="CX"><?php _e('Christmas Island') ?></option>
                        <option value="CC"><?php _e('Cocos (Keeling) Islands') ?></option>
                        <option value="CO"><?php _e('Colombia') ?></option>
                        <option value="KM"><?php _e('Comoros') ?></option>
                        <option value="CD"><?php _e('Congo') ?></option>
                        <option value="CG"><?php _e('Congo') ?></option>
                        <option value="CK"><?php _e('Cook Islands') ?></option>
                        <option value="CR"><?php _e('Costa Rica') ?></option>
                        <option value="HR"><?php _e('Croatia') ?></option>
                        <option value="CU"><?php _e('Cuba') ?></option>
                        <option value="CY"><?php _e('Cyprus') ?></option>
                        <option value="CZ"><?php _e('Czech Republic') ?></option>
                        <option value="DK"><?php _e('Denmark') ?></option>
                        <option value="DJ"><?php _e('Djibouti') ?></option>
                        <option value="DM"><?php _e('Dominica') ?></option>
                        <option value="DO"><?php _e('Dominican Republic') ?></option>
                        <option value="EC"><?php _e('Ecuador') ?></option>
                        <option value="EG"><?php _e('Egypt') ?></option>
                        <option value="SV"><?php _e('El Salvador') ?></option>
                        <option value="GQ"><?php _e('Equatorial Guinea') ?></option>
                        <option value="ER"><?php _e('Eritrea') ?></option>
                        <option value="EE"><?php _e('Estonia') ?></option>
                        <option value="ET"><?php _e('Ethiopia') ?></option>
                        <option value="FK"><?php _e('Falkland Islands (Malvinas)') ?></option>
                        <option value="FO"><?php _e('Faroe Islands') ?></option>
                        <option value="FJ"><?php _e('Fiji') ?></option>
                        <option value="FI"><?php _e('Finland') ?></option>
                        <option value="FR"><?php _e('France') ?></option>
                        <option value="GF"><?php _e('French Guiana') ?></option>
                        <option value="PF"><?php _e('French Polynesia') ?></option>
                        <option value="TF"><?php _e('French Southern Territories') ?></option>
                        <option value="GA"><?php _e('Gabon') ?></option>
                        <option value="GM"><?php _e('Gambia') ?></option>
                        <option value="GE"><?php _e('Georgia') ?></option>
                        <option value="DE"><?php _e('Germany') ?></option>
                        <option value="GH"><?php _e('Ghana') ?></option>
                        <option value="GI"><?php _e('Gibraltar') ?></option>
                        <option value="GR"><?php _e('Greece') ?></option>
                        <option value="GL"><?php _e('Greenland') ?></option>
                        <option value="GD"><?php _e('Grenada') ?></option>
                        <option value="GP"><?php _e('Guadeloupe') ?></option>
                        <option value="GU"><?php _e('Guam') ?></option>
                        <option value="GT"><?php _e('Guatemala') ?></option>
                        <option value="GG"><?php _e('Guernsey') ?></option>
                        <option value="GN"><?php _e('Guinea') ?></option>
                        <option value="GW"><?php _e('Guinea-Bissau') ?></option>
                        <option value="GY"><?php _e('Guyana') ?></option>
                        <option value="HT"><?php _e('Haiti') ?></option>
                        <option value="VA"><?php _e('Holy See (Vatican City State)') ?></option>
                        <option value="HN"><?php _e('Honduras') ?></option>
                        <option value="HK"><?php _e('Hong Kong') ?></option>
                        <option value="HU"><?php _e('Hungary') ?></option>
                        <option value="IS"><?php _e('Iceland') ?></option>
                        <option value="IN"><?php _e('India') ?></option>
                        <option value="ID"><?php _e('Indonesia') ?></option>
                        <option value="IR"><?php _e('Iran') ?></option>
                        <option value="IQ"><?php _e('Iraq') ?></option>
                        <option value="IE"><?php _e('Ireland') ?></option>
                        <option value="IM"><?php _e('Isle of Man') ?></option>
                        <option value="IL"><?php _e('Israel') ?></option>
                        <option value="IT"><?php _e('Italy') ?></option>
                        <option value="JM"><?php _e('Jamaica') ?></option>
                        <option value="JP"><?php _e('Japan') ?></option>
                        <option value="JE"><?php _e('Jersey') ?></option>
                        <option value="JO"><?php _e('Jordan') ?></option>
                        <option value="KZ"><?php _e('Kazakhstan') ?></option>
                        <option value="KE"><?php _e('Kenya') ?></option>
                        <option value="KI"><?php _e('Kiribati') ?></option>
                        <option value="KP"><?php _e('Korea') ?></option>
                        <option value="KR"><?php _e('Korea') ?></option>
                        <option value="KW"><?php _e('Kuwait') ?></option>
                        <option value="KG"><?php _e('Kyrgyzstan') ?></option>
                        <option value="LA"><?php _e('Lao Peoples Democratic Republic') ?></option>
                        <option value="LV"><?php _e('Latvia') ?></option>
                        <option value="LB"><?php _e('Lebanon') ?></option>
                        <option value="LS"><?php _e('Lesotho') ?></option>
                        <option value="LR"><?php _e('Liberia') ?></option>
                        <option value="LY"><?php _e('Libya') ?></option>
                        <option value="LI"><?php _e('Liechtenstein') ?></option>
                        <option value="LT"><?php _e('Lithuania') ?></option>
                        <option value="LU"><?php _e('Luxembourg') ?></option>
                        <option value="MO"><?php _e('Macao') ?></option>
                        <option value="MK"><?php _e('Macedonia') ?></option>
                        <option value="MG"><?php _e('Madagascar') ?></option>
                        <option value="MW"><?php _e('Malawi') ?></option>
                        <option value="MY"><?php _e('Malaysia') ?></option>
                        <option value="MV"><?php _e('Maldives') ?></option>
                        <option value="ML"><?php _e('Mali') ?></option>
                        <option value="MT"><?php _e('Malta') ?></option>
                        <option value="MH"><?php _e('Marshall Islands') ?></option>
                        <option value="MQ"><?php _e('Martinique') ?></option>
                        <option value="MR"><?php _e('Mauritania') ?></option>
                        <option value="MU"><?php _e('Mauritius') ?></option>
                        <option value="YT"><?php _e('Mayotte') ?></option>
                        <option value="MX"><?php _e('Mexico') ?></option>
                        <option value="FM"><?php _e('Micronesia') ?></option>
                        <option value="MD"><?php _e('Moldova') ?></option>
                        <option value="MC"><?php _e('Monaco') ?></option>
                        <option value="MN"><?php _e('Mongolia') ?></option>
                        <option value="ME"><?php _e('Montenegro') ?></option>
                        <option value="MS"><?php _e('Montserrat') ?></option>
                        <option value="MA"><?php _e('Morocco') ?></option>
                        <option value="MZ"><?php _e('Mozambique') ?></option>
                        <option value="MM"><?php _e('Myanmar') ?></option>
                        <option value="NA"><?php _e('Namibia') ?></option>
                        <option value="NR"><?php _e('Nauru') ?></option>
                        <option value="NP"><?php _e('Nepal') ?></option>
                        <option value="AN"><?php _e('Netherlands Antilles') ?></option>
                        <option value="NL"><?php _e('Netherlands') ?></option>
                        <option value="NC"><?php _e('New Caledonia') ?></option>
                        <option value="NZ"><?php _e('New Zealand') ?></option>
                        <option value="NI"><?php _e('Nicaragua') ?></option>
                        <option value="NE"><?php _e('Niger') ?></option>
                        <option value="NG"><?php _e('Nigeria') ?></option>
                        <option value="NU"><?php _e('Niue') ?></option>
                        <option value="NF"><?php _e('Norfolk Island') ?></option>
                        <option value="MP"><?php _e('Northern Mariana Islands') ?></option>
                        <option value="NO"><?php _e('Norway') ?></option>
                        <option value="OM"><?php _e('Oman') ?></option>
                        <option value="PK"><?php _e('Pakistan') ?></option>
                        <option value="PW"><?php _e('Palau') ?></option>
                        <option value="PS"><?php _e('Palestine') ?></option>
                        <option value="PA"><?php _e('Panama') ?></option>
                        <option value="PG"><?php _e('Papua New Guinea') ?></option>
                        <option value="PY"><?php _e('Paraguay') ?></option>
                        <option value="PE"><?php _e('Peru') ?></option>
                        <option value="PH"><?php _e('Philippines') ?></option>
                        <option value="PN"><?php _e('Pitcairn') ?></option>
                        <option value="PL"><?php _e('Poland') ?></option>
                        <option value="PT"><?php _e('Portugal') ?></option>
                        <option value="PR"><?php _e('Puerto Rico') ?></option>
                        <option value="QA"><?php _e('Qatar') ?></option>
                        <option value="RO"><?php _e('Romania') ?></option>
                        <option value="RU"><?php _e('Russian Federation') ?></option>
                        <option value="RW"><?php _e('Rwanda') ?></option>
                        <option value="BL"><?php _e('Saint Barth') ?></option>
                        <option value="SH"><?php _e('Saint Helena') ?></option>
                        <option value="KN"><?php _e('Saint Kitts And Nevis') ?></option>
                        <option value="LC"><?php _e('Saint Lucia') ?></option>
                        <option value="MF"><?php _e('Saint Martin') ?></option>
                        <option value="PM"><?php _e('Saint Pierre And Miquelon') ?></option>
                        <option value="VC"><?php _e('Saint Vincent And The Grenadines') ?></option>
                        <option value="WS"><?php _e('Samoa') ?></option>
                        <option value="SM"><?php _e('San Marino') ?></option>
                        <option value="ST"><?php _e('Sao Tome and Principe') ?></option>
                        <option value="SA"><?php _e('Saudi Arabia') ?></option>
                        <option value="SN"><?php _e('Senegal') ?></option>
                        <option value="RS"><?php _e('Serbia') ?></option>
                        <option value="SC"><?php _e('Seychelles') ?></option>
                        <option value="SL"><?php _e('Sierra Leone') ?></option>
                        <option value="SG"><?php _e('Singapore') ?></option>
                        <option value="SX"><?php _e('Sint Maarten') ?></option>
                        <option value="SK"><?php _e('Slovakia') ?></option>
                        <option value="SI"><?php _e('Slovenia') ?></option>
                        <option value="SB"><?php _e('Solomon Islands') ?></option>
                        <option value="SO"><?php _e('Somalia') ?></option>
                        <option value="ZA"><?php _e('South Africa') ?></option>
                        <option value="SS"><?php _e('South Sudan') ?></option>
                        <option value="ES"><?php _e('Spain') ?></option>
                        <option value="LK"><?php _e('Sri Lanka') ?></option>
                        <option value="SD"><?php _e('Sudan') ?></option>
                        <option value="SR"><?php _e('Suriname') ?></option>
                        <option value="SJ"><?php _e('Svalbard And Jan Mayen') ?></option>
                        <option value="SZ"><?php _e('Swaziland') ?></option>
                        <option value="SE"><?php _e('Sweden') ?></option>
                        <option value="CH"><?php _e('Switzerland') ?></option>
                        <option value="SY"><?php _e('Syrian Arab Republic') ?></option>
                        <option value="TW"><?php _e('Taiwan') ?></option>
                        <option value="TJ"><?php _e('Tajikistan') ?></option>
                        <option value="TZ"><?php _e('Tanzania') ?></option>
                        <option value="TH"><?php _e('Thailand') ?></option>
                        <option value="TL"><?php _e('Timor-Leste') ?></option>
                        <option value="TG"><?php _e('Togo') ?></option>
                        <option value="TK"><?php _e('Tokelau') ?></option>
                        <option value="TO"><?php _e('Tonga') ?></option>
                        <option value="TT"><?php _e('Trinidad and Tobago') ?></option>
                        <option value="TN"><?php _e('Tunisia') ?></option>
                        <option value="TR"><?php _e('Turkey') ?></option>
                        <option value="TM"><?php _e('Turkmenistan') ?></option>
                        <option value="TC"><?php _e('Turks and Caicos Islands') ?></option>
                        <option value="TV"><?php _e('Tuvalu') ?></option>
                        <option value="UG"><?php _e('Uganda') ?></option>
                        <option value="UA"><?php _e('Ukraine') ?></option>
                        <option value="AE"><?php _e('United Arab Emirates') ?></option>
                        <option value="GB"><?php _e('United Kingdom') ?></option>
                        <option value="UM"><?php _e('United States Minor Outlying Islands') ?></option>
                        <option value="US"><?php _e('United States') ?></option>
                        <option value="UY"><?php _e('Uruguay') ?></option>
                        <option value="UZ"><?php _e('Uzbekistan') ?></option>
                        <option value="VU"><?php _e('Vanuatu') ?></option>
                        <option value="VE"><?php _e('Venezuela') ?></option>
                        <option value="VN"><?php _e('Vietnam') ?></option>
                        <option value="VG"><?php _e('Virgin Islands') ?></option>
                        <option value="VI"><?php _e('Virgin Islands') ?></option>
                        <option value="WF"><?php _e('Wallis and Futuna') ?></option>
                        <option value="EH"><?php _e('Western Sahara') ?></option>
                        <option value="YE"><?php _e('Yemen') ?></option>
                        <option value="ZM"><?php _e('Zambia') ?></option>
                        <option value="ZW"><?php _e('Zimbabwe') ?></option>
                    </select>
                </div>
                <div class="md:grid-cols-2 lg:col-span-5 space-y-1">
                    <label class="block" for="meta"><?php _e('Meta (Optional)') ?></label>
                    <input class="w-full text-sm" type="text" name="meta" id="meta" placeholder="<?php _e('Provided by Google') ?>">
                    <small><?php _e('You can use this space to add details like Provider or any additional details.') ?></small>
                </div>
                <div class="md:grid-cols-2 lg:col-span-5 -mt-2">
                    <?php 
                    settings_fields( $this->plugin_name );
                    do_settings_sections( $this->plugin_name );
                    ?>
                    <button type="submit" name="servers" id="servers" class="w-full font-semibold text-sm text-center bg-blue-600 text-white rounded py-2"><?php _e('Save Details') ?></button>
                </div>
            </div>
        </form>
    </div>
    <form id="sort-servers" action="options.php" method="post">
        <input type="hidden" name="from-id">
        <input type="hidden" name="to-id">
        <?php 
        settings_fields( $this->plugin_name );
        do_settings_sections( $this->plugin_name );
        ?>
    </form>
    <form id="delete-server" action="options.php" method="post">
        <input type="hidden" name="delete-id">
        <?php 
        settings_fields( $this->plugin_name );
        do_settings_sections( $this->plugin_name );
        ?>
    </form>
</main>

<div id="global-dns-servers-json" class="hidden"><?php echo json_encode($servers) ?></div>
<input type="file" name="import-file" id="import-file" class="hidden" accept=".csv">
<form id="global-dns-import-form" action="options.php" method="post" enctype="multipart/form-data">
    <textarea class="hidden" name="import-servers" id="import-servers"></textarea>
    <?php 
    settings_fields( $this->plugin_name );
    do_settings_sections( $this->plugin_name );
    ?>
</form>