<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              thehp.in
 * @since             1.0.0
 * @package           Global_Dns
 *
 * @wordpress-plugin
 * Plugin Name:       Global DNS
 * Plugin URI:        https://codecanyon.net/item/global-dns-multiple-server-dns-lookup/25869388
 * Description:       Global DNS allows you to instantly check the DNS records across mutliple servers.
 * Version:           3.0.0
 * Author:            thehp
 * Author URI:        thehp.in
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       global-dns
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('GLOBAL_DNS_VERSION', '3.0.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-global-dns-activator.php
 */
function activate_global_dns() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-global-dns-activator.php';
	Global_Dns_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-global-dns-deactivator.php
 */
function deactivate_global_dns() {
	require_once plugin_dir_path(__FILE__) . 'includes/class-global-dns-deactivator.php';
	Global_Dns_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_global_dns');
register_deactivation_hook(__FILE__, 'deactivate_global_dns');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-global-dns.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_global_dns() {

	$plugin = new Global_Dns();
	$plugin->run();
}
run_global_dns();
