<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/public/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
if (!is_array($servers)) {
    $servers = array();
}
if (!is_array($settings)) {
    $settings = array();
}
echo "<style>";
if (isset($attr['btn-bg-color'])) {
    echo ".global_dns_input input[type=submit] { background: " . $attr['btn-bg-color'] . " !important; border-color: " . $attr['btn-bg-color'] . " !important; }";
}
if (isset($attr['btn-text-color'])) {
    echo ".global_dns_input input[type=submit] { color: " . $attr['btn-text-color'] . " !important; }";
}
if (isset($attr['icon-bg-color'])) {
    echo ".expected-icon { background: " . $attr['icon-bg-color'] . " !important; border-color: " . $attr['icon-bg-color'] . " !important; }";
}
if (isset($attr['icon-text-color'])) {
    echo ".expected-icon { color: " . $attr['icon-text-color'] . " !important; }";
}
echo "</style>";
?>
<div class="global_dns_input">
    <form method="POST" id="global-dns-input">
        <div>
            <input type="text" id="global-dns-domain" name="domain" placeholder="<?php esc_attr_e((isset($attr['input-placeholder'])) ? $attr['input-placeholder'] : 'www.example.com', $this->plugin_name) ?>" required>
            <select name="type" id="global-dns-type">
                <option value="A" title="Host address (dotted quad)" selected="selected"><?php esc_html_e('A', $this->plugin_name) ?></option>
                <option value="MX" title="Mail exchanger (preference value, domain name)"><?php esc_html_e('MX', $this->plugin_name) ?></option>
                <option value="NS" title="Authoritative nameserver (domain name)"><?php esc_html_e('NS', $this->plugin_name) ?></option>
                <option value="CNAME" title="Canonical name for an alias (domain name)"><?php esc_html_e('CNAME', $this->plugin_name) ?></option>
                <option value="TXT" title="Descriptive text (one or more strings)"><?php esc_html_e('TXT', $this->plugin_name) ?></option>
                <option value="PTR" title="Domain name pointer (Provide IP Address)"><?php esc_html_e('PTR', $this->plugin_name) ?></option>
                <option value="CAA" title="Certification Authority Authorization"><?php esc_html_e('CAA', $this->plugin_name) ?></option>
                <option value="SOA" title="Start of Authority"><?php esc_html_e('SOA', $this->plugin_name) ?></option>
                <option value="SRV" title="Service record"><?php esc_html_e('SRV', $this->plugin_name) ?></option>
                <option value="AAAA" title="IP v6 address (address spec with colons)"><?php esc_html_e('AAAA', $this->plugin_name) ?></option>
            </select>
            <?php if (isset($settings['enable_expected_button']) && $settings['enable_expected_button']) { ?>
                <button type="button" class="expected-icon" onclick="document.getElementById('expected-group').classList.toggle('d-none'); document.getElementById('expected').value = ''">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                </button>
            <?php } ?>
            <input type="submit" value="<?php esc_attr_e((isset($attr['btn-text'])) ? $attr['btn-text'] : 'Find', $this->plugin_name) ?>">
        </div>
        <?php if (isset($settings['enable_expected_button']) && $settings['enable_expected_button']) { ?>
            <div id="expected-group" class="d-none">
                <input type="text" class="form-control" id="expected" name="expected" placeholder="Expected Value (Optional)">
            </div>
        <?php } ?>
    </form>
</div>
<div class="global_dns d-none">
    <div id="servers"><?php esc_html_e(json_encode($servers)); ?></div>
    <div id="options"><?php esc_html_e(json_encode($settings)); ?></div>
    <div id="nonce"><?php esc_html_e(wp_create_nonce('wp_rest')); ?></div>
</div>
<?php
if (isset($attr['default-type'])) {
    echo "<script async>document.getElementById('global-dns-type').value = '" . $attr['default-type'] . "'</script>";
}
?>